/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.nio.IntBuffer;
import java.util.Arrays;
import net.optifine.util.ArrayUtils;
import net.optifine.util.BufferUtil;
import org.lwjgl.BufferUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DrawBuffers {
    private String name;
    private final int maxColorBuffers;
    private final int maxDrawBuffers;
    private final IntBuffer drawBuffers;
    private int[] attachmentMappings;
    private IntBuffer glDrawBuffers;

    public DrawBuffers(String name, int maxColorBuffers, int maxDrawBuffers) {
        this.name = name;
        this.maxColorBuffers = maxColorBuffers;
        this.maxDrawBuffers = maxDrawBuffers;
        this.drawBuffers = IntBuffer.wrap(new int[maxDrawBuffers]);
    }

    public int get(int index) {
        return this.drawBuffers.get(index);
    }

    public DrawBuffers put(int attachment) {
        this.resetMappings();
        this.drawBuffers.put(attachment);
        return this;
    }

    public DrawBuffers put(int index, int attachment) {
        this.resetMappings();
        this.drawBuffers.put(index, attachment);
        return this;
    }

    public int position() {
        return this.drawBuffers.position();
    }

    public DrawBuffers position(int newPosition) {
        this.resetMappings();
        this.drawBuffers.position(newPosition);
        return this;
    }

    public int limit() {
        return this.drawBuffers.limit();
    }

    public DrawBuffers limit(int newLimit) {
        this.resetMappings();
        this.drawBuffers.limit(newLimit);
        return this;
    }

    public int capacity() {
        return this.drawBuffers.capacity();
    }

    public DrawBuffers fill(int val) {
        for (int i2 = 0; i2 < this.drawBuffers.limit(); ++i2) {
            this.drawBuffers.put(i2, val);
        }
        this.resetMappings();
        return this;
    }

    private void resetMappings() {
        this.attachmentMappings = null;
        this.glDrawBuffers = null;
    }

    public int[] getAttachmentMappings() {
        if (this.attachmentMappings == null) {
            this.attachmentMappings = DrawBuffers.makeAttachmentMappings((IntBuffer)this.drawBuffers, (int)this.maxColorBuffers, (int)this.maxDrawBuffers);
        }
        return this.attachmentMappings;
    }

    private static int[] makeAttachmentMappings(IntBuffer drawBuffers, int maxColorBuffers, int maxDrawBuffers) {
        int ai;
        int att;
        int i2;
        int[] ams = new int[maxColorBuffers];
        Arrays.fill(ams, -1);
        for (i2 = 0; i2 < drawBuffers.limit(); ++i2) {
            att = drawBuffers.get(i2);
            ai = att - 36064;
            if (ai < 0 || ai >= maxDrawBuffers) continue;
            ams[ai] = ai;
        }
        for (i2 = 0; i2 < drawBuffers.limit(); ++i2) {
            att = drawBuffers.get(i2);
            ai = att - 36064;
            if (ai < maxDrawBuffers || ai >= maxColorBuffers) continue;
            int mi = DrawBuffers.getMappingIndex((int)ai, (int)maxDrawBuffers, (int[])ams);
            if (mi < 0) {
                throw new RuntimeException("Too many draw buffers, mapping: " + ArrayUtils.arrayToString((int[])ams));
            }
            ams[ai] = mi;
        }
        return ams;
    }

    private static int getMappingIndex(int ai, int maxDrawBuffers, int[] attachmentMappings) {
        if (ai < maxDrawBuffers) {
            return ai;
        }
        if (attachmentMappings[ai] >= 0) {
            return attachmentMappings[ai];
        }
        for (int i2 = 0; i2 < maxDrawBuffers; ++i2) {
            if (ArrayUtils.contains((int[])attachmentMappings, (int)i2)) continue;
            return i2;
        }
        return -1;
    }

    public IntBuffer getGlDrawBuffers() {
        if (this.glDrawBuffers == null) {
            this.glDrawBuffers = DrawBuffers.makeGlDrawBuffers((IntBuffer)this.drawBuffers, (int[])this.getAttachmentMappings());
        }
        return this.glDrawBuffers;
    }

    private static IntBuffer makeGlDrawBuffers(IntBuffer drawBuffers, int[] attachmentMappings) {
        IntBuffer glDrawBuffers = BufferUtils.createIntBuffer((int)drawBuffers.capacity());
        for (int i2 = 0; i2 < drawBuffers.limit(); ++i2) {
            int att = drawBuffers.get(i2);
            int ai = att - 36064;
            int attFixed = 0;
            if (ai >= 0 && ai < attachmentMappings.length) {
                attFixed = 36064 + attachmentMappings[ai];
            }
            glDrawBuffers.put(i2, attFixed);
        }
        glDrawBuffers.limit(drawBuffers.limit());
        glDrawBuffers.position(drawBuffers.position());
        return glDrawBuffers;
    }

    public String getInfo(boolean glBuffers) {
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = 0; i2 < this.drawBuffers.limit(); ++i2) {
            int att = this.drawBuffers.get(i2);
            int ai = att - 36064;
            if (glBuffers) {
                int[] ams = this.getAttachmentMappings();
                if (ai >= 0 && ai < ams.length) {
                    ai = ams[ai];
                }
            }
            String attName = this.getIndexName(ai);
            sb2.append(attName);
        }
        return sb2.toString();
    }

    private String getIndexName(int ai) {
        if (ai >= 0 && ai < this.maxColorBuffers) {
            return "" + ai;
        }
        return "N";
    }

    public int indexOf(int att) {
        for (int i2 = 0; i2 < this.limit(); ++i2) {
            if (this.get(i2) != att) continue;
            return i2;
        }
        return -1;
    }

    public String toString() {
        return this.name + ": " + BufferUtil.getBufferString((IntBuffer)this.drawBuffers) + ", mapping: " + ArrayUtils.arrayToString((int[])this.attachmentMappings) + ", glDrawBuffers: " + BufferUtil.getBufferString((IntBuffer)this.glDrawBuffers);
    }
}

